use mavenfuzzyfactory;

-- 1. Yêu cầu 1 – Tìm các trang web có lượt xem nhiều nhất
select pageview_url, count(*) as pvs
from website_pageviews
where created_at < '2012-06-09'
group by pageview_url;

-- 2. Yêu cầu 2 – Tìm tổng số lượng session truy cập mỗi trang web vào lần đầu tiên
create temporary table if not exists first_pv_per_session 
select website_session_id, min(website_pageview_id) as first_pv
from website_pageviews
where created_at < '2012-06-12'
group by website_session_id;

select pageview_url, count(distinct pv.website_session_id) as views
from website_pageviews pv join first_pv_per_session fpv on pv.website_pageview_id = fpv.first_pv
group by pageview_url;

-- 3. Yêu cầu 3 – Phân tích landing page
-- Bảng first_pageviews để tìm ra các pageview_id được truy cập đầu tiên
create temporary table if not exists first_pageviews
select website_session_id, min(website_pageview_id) as min_pageview_id
from website_pageviews
where created_at < '2012-06-14'
group by website_session_id;

-- Bảng session_w_home_landing_page chứa các website_session_id có entry page là '/home'
create temporary table if not exists session_w_home_landing_page
select first_pageviews.website_session_id, website_pageviews.pageview_url as landing_page
from first_pageviews left join website_pageviews
on website_pageviews.website_pageview_id = first_pageviews.min_pageview_id
where website_pageviews.pageview_url = '/home';

-- bảng bounced_sessions để tìm ra các session chỉ chứa 1 một trang web là /home,
-- nếu session chỉ truy cập duy nhất 1 trang là /home thì cũng đồng nghĩa session này đã xảy
-- ra tình trạng thoát phiên
create temporary table if not exists bounced_sessions
select session_w_home_landing_page.website_session_id,
	session_w_home_landing_page.landing_page,
	count(website_pageviews.website_pageview_id) as count_of_pages_viewed
from session_w_home_landing_page left join website_pageviews
on website_pageviews.website_session_id = session_w_home_landing_page.website_session_id
group by session_w_home_landing_page.website_session_id, session_w_home_landing_page.landing_page
having count(website_pageviews.website_pageview_id) = 1;

-- truy vấn này để tìm ra những phiên có trong bảng session_w_home_landing_page
-- nhưng không có trong bảng bounced_sessions, những phiên có trong bảng
-- bounced_sessions chính là những phiên xảy ra tình trạng thoát phiên
select count(distinct session_w_home_landing_page.website_session_id) as sessions,
	count(distinct bounced_sessions.website_session_id) as bounced_sessions,
    count(distinct bounced_sessions.website_session_id)/count(distinct session_w_home_landing_page.website_session_id) as bounced_rate
from session_w_home_landing_page left join bounced_sessions
on session_w_home_landing_page.website_session_id = bounced_sessions.website_session_id
order by session_w_home_landing_page.website_session_id;

-- 4. Yêu cầu 4 – A/B testing
-- Bước 1: Viết câu truy vấn để tìm ra ngày đầu tiên mà ‘/lander-1’ được thêm vào:
select min(created_at) as first_created_at,
	min(website_pageview_id) as first_pageview_id
from website_pageviews
where pageview_url = '/lander-1' and created_at is not null;

-- Bước 2: lọc ra các web_pageview_id trong khoảng thời gian '/lander-1' đã được thêm
create temporary table if not exists first_test_pageviews
select website_pageviews.website_session_id,
	min(website_pageviews.website_pageview_id) as min_pageview_id
from website_pageviews inner join website_sessions
	on website_sessions.website_session_id = website_pageviews.website_session_id
where website_sessions.created_at < '2012-07-28'
	and website_pageviews.website_pageview_id >= 23504
	and utm_source = 'gsearch'
	and utm_campaign = 'nonbrand'
group by website_pageviews.website_session_id;

-- Bước 3: map web_pageview_id và landing page (/home, /lander-1)
create temporary table if not exists nonbrand_test_session_w_landing_page
select first_test_pageviews.website_session_id,
	website_pageviews.pageview_url as landing_page
from first_test_pageviews left join website_pageviews
	on website_pageviews.website_pageview_id = first_test_pageviews.min_pageview_id
where website_pageviews.pageview_url in ('/home', '/lander-1');

-- Bước 4: Viết truy vấn lọc ra các web_session_id bị thoát phiên
create temporary table if not exists test_bounced_sessions
select nonbrand_test_session_w_landing_page.website_session_id,
	nonbrand_test_session_w_landing_page.landing_page,
    count(website_pageviews.website_pageview_id) as count_of_pages_viewed
from nonbrand_test_session_w_landing_page join website_pageviews
	on nonbrand_test_session_w_landing_page.website_session_id = website_pageviews.website_session_id
group by nonbrand_test_session_w_landing_page.website_session_id,
	nonbrand_test_session_w_landing_page.landing_page
having count(website_pageviews.website_pageview_id) = 1;

-- Bước 5: Viết truy vấn tính tỷ lệ thoát phiên của trang '/home', '/lander-1'.
select nonbrand_test_session_w_landing_page.landing_page,
	count(nonbrand_test_session_w_landing_page.website_session_id) as sessions,
    count(test_bounced_sessions.website_session_id) as bounced_sessions,
    count(test_bounced_sessions.website_session_id)/count(nonbrand_test_session_w_landing_page.website_session_id) as bounced_rate
from nonbrand_test_session_w_landing_page left join test_bounced_sessions
	on nonbrand_test_session_w_landing_page.website_session_id = test_bounced_sessions.website_session_id
group by nonbrand_test_session_w_landing_page.landing_page
order by nonbrand_test_session_w_landing_page.landing_page;

-- Nhận xét
-- landing page mới là /lander-1 đạt hiệu quả về mặt giảm tỷ lệ thoát phiên

-- 5. Yêu cầu 5 Thống kê theo tuần
-- Bước 1: Tạo bảng tạm để lọc các phiên thoả mãn điều kiện
create temporary table if not exists sessions_w_min_pv_id_and_view_count
select website_sessions.website_session_id,
	min(website_pageviews.website_pageview_id) as first_pageview_id,
	count(website_pageviews.website_pageview_id) as count_pageviews
from website_sessions left join website_pageviews
	on website_sessions.website_session_id = website_pageviews.website_session_id
where
	website_sessions.created_at > '2012-06-01'
	and website_sessions.created_at < '2012-08-31'
	and website_sessions.utm_source = 'gsearch'
	and website_sessions.utm_campaign = 'nonbrand'
group by website_sessions.website_session_id;

-- Bước 2: Tạo bảng tạm để đếm số lượng count_pageviews trong mỗi phiên => mục
-- đích để lọc ra các phiên bị thoát ở bước sau
create temporary table if not exists sessions_w_counts_lander_and_created_at
select
	sessions_w_min_pv_id_and_view_count.website_session_id,
	sessions_w_min_pv_id_and_view_count.first_pageview_id,
	sessions_w_min_pv_id_and_view_count.count_pageviews,
	website_pageviews.pageview_url as landing_page,
	website_pageviews.created_at as session_created_at
from sessions_w_min_pv_id_and_view_count left join website_pageviews
	on sessions_w_min_pv_id_and_view_count.first_pageview_id = website_pageviews.website_pageview_id;
    
-- Bước 3: Hiển thị tỷ lệ thoát phiên trên toàn trang web theo tuần, đồng thời hiển thị cả số
-- phiên được phân vào /home và số phiên được phân vào /lander-1 
select
	first_day_of_week(session_created_at) as week_start_date,
    count(website_session_id) total_sessions,
    sum(case count_pageviews when 1 then 1 else 0 end)/count(website_session_id) as bounce_sessions,
    sum(case landing_page when '/home' then 1 else 0 end) as home_sessions,
    sum(case landing_page when '/lander-1' then 1 else 0 end) as lander_sessions
from sessions_w_counts_lander_and_created_at
group by first_day_of_week(session_created_at)
order by first_day_of_week(session_created_at);